package models

import "log"

type ParseIpHostsIps struct {
	Id      int `db:"id"`
	IpId    int `db:"ip_id"`
	HostId  int `db:"host_id"`
	TableId int `db:"table_id"`
}

func BatchParseIpHostsIps(tableId int, idsIps []int, idsHosts []int) {
	var args []ParseIpHostsIps
	for _, ip := range idsIps {
		for _, host := range idsHosts {
			i := ParseIpHostsIps{}
			i.IpId = ip
			i.TableId = tableId
			i.HostId = host
			args = append(args, i)
		}
	}

	_, err := db.NamedExec("INSERT INTO parse_ip_hosts_ips (ip_id, host_id, table_id) VALUES(:ip_id, :host_id, :table_id)", args)
	if err != nil {
		log.Fatalln(err)
	}
}